#!/usr/bin/env python3
"""
Oracle DB MCP Server - Standalone Launcher

This script launches the Oracle DB MCP server as a standalone service
using configuration from .env file.
"""

import os
import sys
from pathlib import Path

# Add the project root to the Python path
project_root = Path(__file__).parent
sys.path.insert(0, str(project_root))

from dotenv import load_dotenv

# Load environment variables from .env file
load_dotenv()


def main():
    """Main entry point for standalone server."""
    # Get configuration from environment
    host = os.getenv("MCP_HOST", "127.0.0.1")
    port = int(os.getenv("MCP_PORT", "7087"))
    transport = os.getenv("MCP_TRANSPORT", "streamable-http")
    log_level = os.getenv("MCP_LOG_LEVEL", "INFO")

    print(f"Starting Oracle DB MCP Server...")
    print(f"Transport: {transport}")
    print(f"Host: {host}")
    print(f"Port: {port}")
    print(f"Log Level: {log_level}")

    # Import and run the server
    from server.main import main as server_main

    # Override sys.argv to pass the configuration
    sys.argv = [
        "server/main.py",
        "--host",
        host,
        "--port",
        str(port),
        "--log-level",
        log_level,
    ]

    import asyncio

    asyncio.run(server_main())


if __name__ == "__main__":
    main()
