# Oracle DB MCP Tool - Active Context

## Current Status

All core tools implemented and MCP server functional. Recent updates:

- db.get_server_info tool added and registered in FastMCP (streamable-http transport only)
- db_list_schemas tool removed to prevent unnecessary schema clarification calls by LLMs
- Stdio transport removed for simplicity (single transport: streamable-http)

Tool call to db_get_server_info succeeded in registration but failed due to Oracle client architecture mismatch (expected in dev env). Server starts successfully.

## Current Focus

Resolve Oracle client compatibility for full end-to-end testing. Monitor LLM usage patterns with simplified toolset.

## Next Steps (ordered)

1. Configure 32-bit Oracle Instant Client to resolve DPI-1047 error.
2. Test all tools with live database connection.
3. Update USAGE.md with simplified transport instructions.
4. Consider ADR for toolset evolution based on usage.

## Acceptance Criteria

- MCP server starts and connects to Oracle Database without client errors
- All 12 tools (ping, session_info, db_query, db_list_objects, db_describe_object, db_get_ddl, db_explain_plan, db_exec_plsql, db_create_or_replace_proc, db_call_proc, db_run_test, db_get_server_info) execute correctly
- Safety limits enforced across operations
- VS Code MCP integration seamless
- Error handling informative; no crashes
- No sensitive data exposure

## Known Constraints

- 32-bit Python and Oracle Instant Client required
- cx_Oracle 8.3.0 locked for compatibility
- Credentials via env vars only
- Streamable-http transport only (stdio removed)
- Database at 10.0.0.18:1521/v8

## Dependencies

- Oracle Database at specified DSN
- 32-bit Python runtime
- 32-bit Oracle Instant Client in PATH
- VS Code MCP extension
- Network access to DB

## Risk Mitigation

- Timeouts and limits prevent issues
- Error handling for client mismatches
- Fallbacks in tool implementations
- Env var config for security

## Related Documentation

- See projectbrief.md for scope
- See productContext.md for user stories
- See systemPatterns.md for ADRs
- See techContext.md for config
- See progress.md for history

### 2025-11-23 — Architect: Umb applied, handoff note

- Summary of changes (code & docs):

  - Curated MCP public tools exposed and aligned with documentation: [`server/mcp_server.py`](server/mcp_server.py:1)
  - FastMCP registrations now use dotted tool names and include underscored aliases for backward compatibility: [`server/main.py`](server/main.py:1)
  - Merged and enhanced ping to include connectivity, HotelId lookup, Oracle version and usage hint: [`server/oracle/pool.py`](server/oracle/pool.py:151)
  - Relaxed db.query restrictions in test environment (no forced truncation; optional hints): [`server/oracle/exec.py`](server/oracle/exec.py:320)
  - Updated machine-oriented usage and examples: [`server/oracle/usage_description.md`](server/oracle/usage_description.md:1)
  - ADR added documenting the naming decision and transition plan: [`memory-bank/systemPatterns.md`](memory-bank/systemPatterns.md:1)
  - Progress entry appended: [`memory-bank/progress.md`](memory-bank/progress.md:1)

- Acceptance criteria for this handoff (must be verified before final merge):

  1. Running MCP server exposes the curated tool names (dotted) OR continues to support underscored aliases until clients migrate.
  2. `ping` returns connectivity OK, optional HotelId lookup (if present), oracle_version, and usage_instructions.
  3. `db.query` executes parameterized queries and returns structured JSON (status, columns, rows, row_count).
  4. Docs reflect current behavior and examples: [`server/oracle/usage_description.md`](server/oracle/usage_description.md:1).
  5. ADR-007 present in systemPatterns with rationale and migration plan: [`memory-bank/systemPatterns.md`](memory-bank/systemPatterns.md:1).

- Next steps (ordered):

  1. Orchestrator / User: restart the MCP server to pick up explicit dotted registrations (if not already restarted).
  2. Run integration checks: call `ping` and `db.query` via MCP (I can run these on request).
  3. Run markdown linter across repo `.md` files and fix parse issues; commit fixes.
  4. Run full test suite including async tests (install pytest-asyncio) and address regressions if any.
  5. After a 30-day transition window, remove underscored aliases and update ADR to reflect removal.

- Blockers / Notes:

  - Live server process must be restarted to reflect code edits to tool registrations. I confirmed current running server responds and supports both dotted names (in docs) and underscored aliases; after your restart I will re-check and confirm registry.
  - Security note: db.query is intentionally permissive for this test environment. Do not enable in production without controls.

- Handoff: ready for Orchestrator acknowledgement and merge into mainline. I performed an initial umb: changes are recorded in memory bank and ADR created.
