# Oracle DB MCP Tool - Product Context

## Problem Statement

Developers working with Oracle Database need a seamless way to execute SQL queries and PL/SQL code directly from their development environment. Currently, there's no direct integration between VS Code and Oracle Database that allows for quick database interactions without switching tools or contexts.

## Goals

- Enable direct SQL and PL/SQL execution from VS Code
- Provide database metadata exploration capabilities
- Support stored procedure development and testing
- Implement safety controls to prevent accidental data issues
- Create a lightweight, focused tool without unnecessary complexity

## User Stories

### As a developer, I want to:

- Execute SQL queries directly from VS Code so that I can quickly test and retrieve data without leaving my editor
- Run PL/SQL blocks for complex operations so that I can perform database tasks efficiently
- Browse database metadata (schemas, objects, DDL) so that I can understand database structures
- Create and test stored procedures so that I can develop database logic iteratively
- Set connection parameters through environment variables so that I can easily configure different database connections
- Have built-in safety limits (timeout, row limits) so that I can prevent accidental expensive operations

## UX Principles

- **Simplicity**: Focus on core functionality without unnecessary features
- **Safety**: Implement reasonable limits to prevent accidental issues
- **Integration**: Seamless VS Code integration through MCP protocol
- **Flexibility**: Support various Oracle Database operations through a unified interface
- **Transparency**: Clear error messages and execution feedback

## Target Environment

- VS Code as the primary development environment
- Oracle Database as the data source
- 32-bit Python runtime for compatibility with existing infrastructure
- Windows development environment

## Key Interactions

1. Developer writes SQL/PL/SQL in VS Code
2. MCP server receives the request
3. Server executes the query against Oracle Database
4. Results are returned and displayed in VS Code
5. Developer can continue iterating based on results

## Related Documentation

- See [`projectbrief.md`](memory-bank/projectbrief.md) for project scope and constraints
- See [`systemPatterns.md`](memory-bank/systemPatterns.md) for MCP protocol architecture
- See [`techContext.md`](memory-bank/techContext.md) for VS Code integration details
- See [`activeContext.md`](memory-bank/activeContext.md) for implementation roadmap
