# Oracle DB MCP Tool - Project Brief

## Project Overview

Creating a simple MCP (Model Context Protocol) tool for VS Code that enables SQL and PL/SQL execution in Oracle Database through a 32-bit Python interface.

## Scope

### In Scope

- MCP server for Oracle Database connectivity
- SQL query execution with safety limits
- PL/SQL block execution
- Database metadata exploration
- Stored procedure creation and testing
- Simple security controls (timeout, row limits, text size limits)
- Manual authentication via environment variables

### Out of Scope

- RAG (Retrieval-Augmented Generation) functionality
- Caching mechanisms
- Knowledge storage features
- Complex security measures
- Automatic authentication systems

## Success Criteria

- MCP server successfully connects to Oracle Database
- All defined database operations execute correctly
- Safety limits (timeout, max rows, text size) are enforced
- Integration with VS Code MCP client works seamlessly
- Documentation enables easy setup and usage

## Stakeholders

- Developer: Primary user and implementer
- Oracle Database: Data source and execution environment
- VS Code: Development environment and MCP client

## Constraints

- Must use 32-bit Python at D:\Dropbox\dev\python\python.exe
- Must use cx_Oracle 8.3.0 for database connectivity
- Oracle Instant Client 32-bit required
- Environment variables for authentication
- No complex security implementations

## Timeline

Development will follow the staged approach outlined in the project plan:

1. Setup and Connectivity
2. Query and Metadata
3. PL/SQL Operations
4. MCP Integration
5. UX Improvements

## Related Documentation

- See [`productContext.md`](memory-bank/productContext.md) for detailed user stories and UX principles
- See [`systemPatterns.md`](memory-bank/systemPatterns.md) for architecture decisions and component design
- See [`techContext.md`](memory-bank/techContext.md) for technical implementation details
- See [`activeContext.md`](memory-bank/activeContext.md) for current focus and next steps
- See [`progress.md`](memory-bank/progress.md) for development progress tracking
