import asyncio
import json
import traceback
from server.oracle.pool import OraclePool
from server.oracle.exec import OracleExecutor


async def run():
    try:
        executor = OracleExecutor(OraclePool())
        res = await executor.query(
            "SELECT * FROM wuss WHERE wuss_name LIKE :wname",
            params={"wname": "%Hotelid%"},
            max_rows=500,
            timeout_s=30,
        )
        print(json.dumps(res, default=str, ensure_ascii=False, indent=2))
    except Exception:
        traceback.print_exc()


if __name__ == "__main__":
    asyncio.run(run())
