MCP tool for Oracle Database. Default schema: V8LIVE.

Note: Public tools exposed: sql.select, sql.execute, db.ping.

sql.select — Execute SELECT queries that return rows. Parameters:

- sql (string): SELECT statement to execute
- params (object, optional): bind parameters, e.g. {"region":"EMEA"}
- max_rows (integer, optional)
- timeout_s (integer, optional)

Example call:

```json
{
	"sql": "SELECT hotel_id, hotel_name FROM hotels WHERE region = :region",
	"params": { "region": "EMEA" },
	"max_rows": 100,
	"timeout_s": 60
}
```

Success response:

```json
{
	"columns": ["HOTEL_ID", "HOTEL_NAME"],
	"rows": [
		[123, "Hotel A"],
		[124, "Hotel B"]
	]
}
```

sql.execute — Execute DML, DDL or PL/SQL blocks. Parameters:

- sql (string): SQL statement or PL/SQL block to execute
- params (object, optional): bind parameters. Provide null or omit a bind to treat it as an OUT bind.
- timeout_s (integer, optional)

Example (DML):

```json
{
	"sql": "UPDATE wdat SET wdat_value = :v WHERE wdat_name = :n",
	"params": { "v": "NEW", "n": "COUNTER" }
}
```

Response (DML):

```json
{
	"rows_affected": 1,
	"message": "Update successful",
	"query": "UPDATE wdat SET ..."
}
```

Example (PL/SQL with OUT bind):

```json
{
	"sql": "BEGIN :ret := my_func(:arg); END;",
	"params": { "arg": 123 }
}
```

Response (PL/SQL):

```json
{
	"return_value": "ResultString",
	"rows_affected": -1,
	"output_values": { "ret": "ResultString" }
}
```

db.ping — Diagnostics and metadata. No parameters.

Example call:

```json
{}
```

Success response:

```json
{
  "connected": true,
  "db_version": "Oracle Database 12c ...",
  "agent_version": "1.0.0",
  "capabilities": ["sql.select", "sql.execute", "db.ping"],
  "settings": { "thick_mode": false, "encoding": "cp1251" },
  "details": { "dsn": "10.0.0.18:1521/v8", "elapsed_ms": 12.3, "checks": { ... } }
}
```

Errors: always returned as JSON with status and details:

```json
{ "status": "error", "message": "...", "code": "ORA-00942" }
```
