
(function(jQuery){
	var arrTables = {};
	var blockingStyle = {
		baseZ: 40,
		message: "<div id=_loader></div>",
		css: { 
			border: 'none',
			width: 28,
			height: 28,
			background: 'transparent'
		},
		overlayCSS: {
			backgroundColor: '#fff', 
			opacity: 1,
			"-webkit-border-radius": 4,
			"-moz-border-radius": 4,
			"border-radius": 4
		}
	};
	
	jQuery.fn.Suite8Dashboard = function() {
		init.call(this);
	};
	
	function init() {
		var self = this;
		
		var sections = $('.section', self);//.block(blockingStyle);
		$('.footer', sections).css({
			position: "absolute",
			bottom: 0
		});
		
		setTimeout(function(){
			__initSection(sections);
		}, 100);
		
		$(window)
		.off('resize')
		.on('resize', function() {
			setTimeout(function() {
				__initSection(sections);
			}, 0);
		});
		
		//$(window).resize();
	}
	
	function __initSection(sections) {
		$(sections).each(function(i, el) {
			var _content = $('.content', el);
			
			if(!$(el).attr('sid'))
				$(el).attr('sid', "s" + (new Date).getTime());
						
			var sh = $('.section-content', el).height() || 0;
			var hh = $('h2', el).height() || 0;
			var fh = $('.footer', el).height() || 0;
			var df = 0; /*$('.dataTables_filter', el).height() || 24;*/

			_content.height(sh-hh-fh-df);
			var ch = _content.height() - 24;

			var _tableData = $('table:eq(0)', el);

			if(_tableData.get(0)) {
				// get columns
				var aoColumns = [];
				_tableData.find("thead > tr:eq(0) > th").each(function(i, th) {
					if($(th).data("column-type") == "number") {
						aoColumns.push({"sType": "num-html"});
					}
					else {
						aoColumns.push(null);
					}
				});
			
				if(arrTables[$(el).attr('sid')])
					arrTables[$(el).attr('sid')].fnDestroy();

				var t = _tableData
					.addClass('display')
					.dataTable({
						"sScrollX": "100%",
						"sScrollXInner": "100%",
						"sScrollY": ch,
						"bScrollCollapse": true,
						"bPaginate": false,
						"bLengthChange": false,
						"bFilter": true,
						"bSort": true,
						"bInfo": false,
						"bAutoWidth": false,
						"aaSorting": [],
						"aoColumns": aoColumns,
						"bRetrieve": true,
						"oLanguage": {
							"sSearch": ""
						},
						"fnPreDrawCallback": function(/*oSettings*/) {
							//$(el).css({visibility: "hidden"});
						},
						"fnInitComplete": function(/*oSettings, json*/) {
							$(el).css({visibility: "visible"});
						}
					});

				arrTables["" + $(el).attr('sid')] = t;

				// hide filter if data not exist or browser is mobile version
				if(/mobile/im.test(navigator.userAgent) && !/ipad/im.test(navigator.userAgent)) {
					$(el).find(".dataTables_filter").hide();
				}
				else {
					var emptyDataTable = $(".dataTables_empty", t);
					if(emptyDataTable.get(0)) {
						emptyDataTable.parents(".dataTables_wrapper").find(".dataTables_filter").hide();
					}
				}
			}

			$(el).css({visibility: "visible"});
		});
	}
})(jQuery);

// ----------------------------------------------------------------
// executing
// ----------------------------------------------------------------

$(document).ready(function() {
// define sorting rules/plugins -------------------------------

jQuery.extend(jQuery.fn.dataTableExt.oSort, {
	"num-html-pre": function ( a ) {
		var x = a.replace( /<.*?>/g, "" ).replace( /,/, "." );
		return parseFloat( x );
	},
 
	"num-html-asc": function ( a, b ) {
		return ((a < b) ? -1 : ((a > b) ? 1 : 0));
	},
 
	"num-html-desc": function ( a, b ) {
		return ((a < b) ? 1 : ((a > b) ? -1 : 0));
	}
});

// ----------------------------------------------------------------
	$('.section-body').Suite8Dashboard();
	
});